@extends('admin.template')
@section('icerik')

<form method="POST" action="{{ route('home.hizmetler.kaydet')}}">
    {{ csrf_field() }}

    <div class="container-fluid">
    <div class="row">
        <div class="col-lg-6">
            <div class="card card-dark">
                <div class="card-header">
                    <h5 class="m-0">Hizmet Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" class="form-control" name="isim"  value="" placeholder='Hizmet Adı'>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-sm-4">
                            <div class="input-group input-group">
                                <input type='currency'  name="fiyat" class="form-control" placeholder='Fiyat' />
                              </div>
                        </div>
                        <div class="col-sm-4">
                            <input type="text" name="kdv" class="form-control"  placeholder="KDV %" value="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-5">
                            <div class="input-group input-group">
                                <button type="submit" name="ekle" class="btn btn-success btn-block">EKLE</button>
                              </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        </div>
  <!-- /.row -->
</div>
</form>
</div>
@endsection

@section('css')
<link rel="stylesheet" href="https://kendo.cdn.telerik.com/2020.2.617/styles/kendo.default-v2.min.css" />

@endsection

@section('js')

<script src="https://kendo.cdn.telerik.com/2020.2.617/js/jquery.min.js"></script>

<script src="https://kendo.cdn.telerik.com/2020.2.617/js/kendo.all.min.js"></script>
<script>
    $(document).ready(function() {
        // create NumericTextBox from input HTML element
        $("#numeric").kendoNumericTextBox();

        // create Curerncy NumericTextBox from input HTML element
        $("#currency").kendoNumericTextBox({
            format: "c",
            decimals: 3
        });

        // create Percentage NumericTextBox from input HTML element
        $("#percentage").kendoNumericTextBox({
            format: "p0",
            min: 0,
            max: 0.1,
            step: 0.01
        });

        // create NumericTextBox from input HTML element using custom format
        $("#custom").kendoNumericTextBox({
            format: "#.00 kg"
        });
    });
</script>
@endsection
